-- lib/managers/customsafehousemanager

function CustomSafehouseManager:is_being_raided()
	if not self:unlocked() or not self:has_entered_safehouse() then
		return false
	end
	local server_time = self:_get_server_time() or 0
	return 300 <= server_time - (self._global._spawn_cooldown or 0) -- 10min == 600s, change this is you want a different interval
end

function CustomSafehouseManager:ignore_raid()
	self:remove_combat_contract()
	self:spawn_safehouse_contract()
	self._global._spawn_cooldown = Steam:server_time()
end